// Copyright (c) Trend Micro Inc. 2016, All Rights Reserved

package com.trendmicro.ds.restapisamples.appcontrol;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.trendmicro.ds.appcontrol.rest.object.DescribeTrustedUpdateModeResponse;
import com.trendmicro.ds.appcontrol.rest.object.ModifyTrustedUpdateModeRequest;
import com.trendmicro.ds.restapisamples.DeepSecurityClient;

/**
 * ModifyAutoAuthorizationMode
 *
 * This sample application shows how to use the Deep Security Manager REST API
 * to build an inventory on a computer.
 */
public class ModifyAutoAuthorizationMode {

	private static final String USAGE = "ModifyAutoAuthorizationMode <DSM URL> <username> <password> [<tenant>] hostID <on|off> <duration>\n" +
		"This sample application shows how to use the Deep Security Manager REST API\n" +
		"to modify the auto-authorization mode on a computer.";

	private static final Logger logger = Logger.getLogger(ModifyAutoAuthorizationMode.class.getName());

	/**
	 * The main entry point.
	 *
	 * @param args see USAGE.
	 */
	public static void main(String[] args) {
		if (args.length < 6) {
			logger.warning(USAGE);
			return;
		}

		if (args.length == 6) {
			new ModifyAutoAuthorizationMode().run(args[0], args[1], args[2], null, args[3], args[4], args[5]);
		} else {
			new ModifyAutoAuthorizationMode().run(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
		}
	}

	private void run(String baseUrl, String username, String password, String tenant, String hostIDString, String mode, String durationString) {
		try (DeepSecurityClient client = new DeepSecurityClient(baseUrl, username, password, tenant)) {

			/*
			 * You should <strong>only</strong> use this in a secure development environment, and <strong>never</strong>
			 * use it over an untrusted network. Disabling the trust manager will turn off the validation process that
			 * checks whether the server you are connecting to is the one you expect, and can result in your connection
			 * being hijacked, your credentials stolen, and general catastrophe. Use with great caution!
			 */
			// client.disableTrustManager();

			Integer hostID = Integer.valueOf(hostIDString);
			boolean enabled = mode.equalsIgnoreCase("on");

			client.modifyTrustedUpdateMode(hostID, new ModifyTrustedUpdateModeRequest()
					.withEnabled(Boolean.valueOf(enabled))
					.withDuration(Integer.valueOf(durationString)));

			DescribeTrustedUpdateModeResponse.State desiredState = enabled ? DescribeTrustedUpdateModeResponse.State.ON : DescribeTrustedUpdateModeResponse.State.OFF;

			logger.info("Auto-authorization mode " + desiredState + " requested. Will check on state in 10 seconds...");

			DescribeTrustedUpdateModeResponse describeTrustedUpdateModeResponse;
			do {
				Thread.sleep(10000);
				describeTrustedUpdateModeResponse = client.describeTrustedUpdateMode(hostID);
				logger.info("Auto-authorization mode: " + describeTrustedUpdateModeResponse.getState());
			} while (!describeTrustedUpdateModeResponse.getState().equals(desiredState));

			logger.info("Auto-authorization mode is " + describeTrustedUpdateModeResponse.getState() + "! Share And Enjoy.");

		} catch (DeepSecurityClient.ClientException e) {
			logger.log(Level.SEVERE, "There was an error communicating with the server: " + e.getMessage());
		} catch (Exception e) {
			// Some other error happened, usually related to network communication problems.
			logger.log(Level.SEVERE, "There was an error communicating with the server.", e);
		}
	}

}