// Copyright (c) Trend Micro Inc. 2016, All Rights Reserved

package com.trendmicro.ds.restapisamples.appcontrol;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.trendmicro.ds.appcontrol.rest.object.AppControlPolicyParameters;
import com.trendmicro.ds.appcontrol.rest.object.AppControlPolicyParameters.ActivationState;
import com.trendmicro.ds.appcontrol.rest.object.ModifyApplicationControlPolicyRequest;
import com.trendmicro.ds.restapisamples.DeepSecurityClient;

/**
 * EnableAppControl
 *
 * This sample application shows how to use the Deep Security Manager REST API
 * to enable application control in a policy.
 */
public class EnableAppControl {

	private static final String USAGE = "EnableAppControl <DSM URL> <username> <password> [<tenant>] policyID <on|off>\n" +
		"This sample application shows how to use the Deep Security Manager REST API\n" +
		"to apply a ruleset in a policy.";

	private static final Logger logger = Logger.getLogger(EnableAppControl.class.getName());

	/**
	 * The main entry point.
	 *
	 * @param args see USAGE.
	 */
	public static void main(String[] args) {
		if (args.length < 5) {
			logger.warning(USAGE);
			return;
		}

		if (args.length == 5) {
			new EnableAppControl().run(args[0], args[1], args[2], null, args[3], args[4]);
		} else {
			new EnableAppControl().run(args[0], args[1], args[2], args[3], args[4], args[5]);
		}
	}

	private void run(String baseUrl, String username, String password, String tenant, String policyIDString, String state) {
		try (DeepSecurityClient client = new DeepSecurityClient(baseUrl, username, password, tenant)) {

			/*
			 * You should <strong>only</strong> use this in a secure development environment, and <strong>never</strong>
			 * use it over an untrusted network. Disabling the trust manager will turn off the validation process that
			 * checks whether the server you are connecting to is the one you expect, and can result in your connection
			 * being hijacked, your credentials stolen, and general catastrophe. Use with great caution!
			 */
			// client.disableTrustManager();

			Integer policyID = Integer.valueOf(policyIDString);

			ActivationState desiredState = state.equalsIgnoreCase("on") ? ActivationState.ON : ActivationState.OFF;
			client.modifyApplicationControlPolicy(policyID, new ModifyApplicationControlPolicyRequest().withAppControlPolicyParameters(new AppControlPolicyParameters()
				.withState(desiredState)
			));

			logger.info("Updated policy " + policyID + " to turn application control " + desiredState);

		} catch (DeepSecurityClient.ClientException e) {
			logger.log(Level.SEVERE, "There was an error communicating with the server: " + e.getMessage());
		} catch (Exception e) {
			// Some other error happened, usually related to network communication problems.
			logger.log(Level.SEVERE, "There was an error communicating with the server.", e);
		}
	}

}