// Copyright (c) Trend Micro Inc. 2016, All Rights Reserved

package com.trendmicro.ds.restapisamples.appcontrol;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.trendmicro.ds.appcontrol.rest.object.AppControlPolicyParameters;
import com.trendmicro.ds.appcontrol.rest.object.AppControlPolicyParameters.ActivationState;
import com.trendmicro.ds.appcontrol.rest.object.AppControlPolicyParameters.WhitelistMode;
import com.trendmicro.ds.appcontrol.rest.object.ModifyApplicationControlPolicyRequest;
import com.trendmicro.ds.restapisamples.DeepSecurityClient;

/**
 * ApplyRuleset
 *
 * This sample application shows how to use the Deep Security Manager REST API
 * to apply a ruleset in a policy.
 */
public class ApplyRuleset {

	private static final String USAGE = "ApplyRuleset <DSM URL> <username> <password> [<tenant>] policyID rulesetID lockdown\n" +
		"This sample application shows how to use the Deep Security Manager REST API\n" +
		"to apply a ruleset in a policy.";

	private static final Logger logger = Logger.getLogger(ApplyRuleset.class.getName());

	/**
	 * The main entry point.
	 *
	 * @param args see USAGE.
	 */
	public static void main(String[] args) {
		if (args.length < 6) {
			logger.warning(USAGE);
			return;
		}

		if (args.length == 6) {
			new ApplyRuleset().run(args[0], args[1], args[2], null, args[3], args[4], args[5]);
		} else {
			new ApplyRuleset().run(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
		}
	}

	private void run(String baseUrl, String username, String password, String tenant, String policyIDString, String rulesetIDString, String lockdownString) {
		try (DeepSecurityClient client = new DeepSecurityClient(baseUrl, username, password, tenant)) {

			/*
			 * You should <strong>only</strong> use this in a secure development environment, and <strong>never</strong>
			 * use it over an untrusted network. Disabling the trust manager will turn off the validation process that
			 * checks whether the server you are connecting to is the one you expect, and can result in your connection
			 * being hijacked, your credentials stolen, and general catastrophe. Use with great caution!
			 */
			// client.disableTrustManager();

			Integer policyID = Integer.valueOf(policyIDString);
			Long rulesetID = Long.valueOf(rulesetIDString);

			Boolean lockdown = Boolean.valueOf(lockdownString);

			client.modifyApplicationControlPolicy(policyID, new ModifyApplicationControlPolicyRequest().withAppControlPolicyParameters(new AppControlPolicyParameters()
				.withState(ActivationState.ON)
				.withLockdown(lockdown)
				.withRulesetID(rulesetID)
				.withWhitelistMode(WhitelistMode.SHARED)
			));

			logger.info("Updated policy " + policyID + " to use ruleset " + rulesetID + " with lockdown = " + lockdown);

		} catch (DeepSecurityClient.ClientException e) {
			logger.log(Level.SEVERE, "There was an error communicating with the server: " + e.getMessage());
		} catch (Exception e) {
			// Some other error happened, usually related to network communication problems.
			logger.log(Level.SEVERE, "There was an error communicating with the server.", e);
		}
	}

}