// Copyright (c) Trend Micro Inc. 2014, All Rights Reserved

package com.trendmicro.ds.restapisamples;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.trendmicro.ds.restapisamples.DeepSecurityClient;

/**
 * Ping
 *
 * This sample application shows how to use the Deep Security Manager REST API
 * to confirm that the Deep Security Manager is running.
 */
public class Ping {

	private static final String USAGE = "Ping <DSM URL> <username> <password> [<tenant>]\n" +
			"This sample application shows how to use the Deep Security Manager REST API\n" +
			"to confirm that the Deep Security Manager is running.";

	private static final Logger logger = Logger.getLogger(Ping.class.getName());

	/**
	 * The main entry point.
	 *
	 * @param args see USAGE.
	 */
	public static void main(String[] args) {
		if (args.length < 3) {
			logger.warning(USAGE);
			return;
		}

		new Ping().run(args[0], args[1], args[2], args.length < 4 ? null : args[3]);
	}

	/**
	 * Run the ping sample.
	 *
	 * @param baseUrl base URL for the Deep Security Manager REST API (for example: {@code https://dsm.example.com/rest})
	 * @param username username to use when accessing the Deep Security Manager REST API
	 * @param password password to use when accessing the Deep Security Manager REST API
	 * @param tenant tenant name to use when accessing the Deep Security Manager REST API. If the system is not multi-tenant or if you are accessing the primary tenant, pass {@code null}.
	 */
	private void run(String baseUrl, String username, String password, String tenant) {
		try (DeepSecurityClient client = new DeepSecurityClient(baseUrl, username, password, tenant)) {

			/*
			 * You should <strong>only</strong> use this in a secure development environment, and <strong>never</strong>
			 * use it over an untrusted network. Disabling the trust manager will turn off the validation process that
			 * checks whether the server you are connecting to is the one you expect, and can result in your connection
			 * being hijacked, your credentials stolen, and general catastrophe. Use with great caution!
			 */
			// client.disableTrustManager();

			client.ping();

			logger.log(Level.INFO, "ok!");

		} catch (DeepSecurityClient.ClientException e) {
			logger.log(Level.SEVERE, "There was an error communicating with the server: " + e.getMessage());
		} catch (Exception e) {
			// Some other error happened, usually related to network communication problems.
			logger.log(Level.SEVERE, "There was an error communicating with the server.", e);
		}
	}

}