/*
 * Decompiled with CFR 0.152.
 */
package com.trendmicro.ds.platform.rest.object.smartfolder;

public class Model {
    public static KeyGroup getGroupForKey(Key key) {
        KeyGroup keyGroup = key.getKeyGroup();
        if (keyGroup == null) {
            throw new IllegalStateException("Unknown Smart Folder Key : " + (Object)((Object)key));
        }
        return keyGroup;
    }

    public static enum ValidationType {
        CREATE("CREATE"),
        PREVIEW("PREVIEW"),
        UPDATE("UPDATE");

        private final String text;

        private ValidationType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum RecommendationScanLastRunTimeSecondardyValues {
        DAYS("DAYS"),
        MINUTES("MINUTES"),
        HOURS("HOURS"),
        WEEKS("WEEKS");

        private final String text;

        private RecommendationScanLastRunTimeSecondardyValues(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum KeyGroup {
        GENERAL("GENERAL"),
        AWS("AWS"),
        AZURE("AZURE"),
        GCP("GCP"),
        VCENTER("VCENTER"),
        VCLOUD("VCLOUD"),
        ACTIVE_DIRECTORY("ACTIVE_DIRECTORY");

        private final String text;

        private KeyGroup(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum Key {
        GENERAL_HOST_NAME("GENERAL_HOST_NAME", KeyGroup.GENERAL),
        GENERAL_DISPLAY_NAME("GENERAL_DISPLAY_NAME", KeyGroup.GENERAL),
        GENERAL_GROUP_NAME("GENERAL_GROUP_NAME", KeyGroup.GENERAL),
        GENERAL_OS("GENERAL_OS", KeyGroup.GENERAL),
        GENERAL_IP("GENERAL_IP", KeyGroup.GENERAL),
        GENERAL_POLICY("GENERAL_POLICY", KeyGroup.GENERAL),
        GENERAL_AGENT_ACTIVATED("GENERAL_AGENT_ACTIVATED", KeyGroup.GENERAL),
        GENERAL_DOCKER_RUNNING("GENERAL_DOCKER_RUNNING", KeyGroup.GENERAL),
        GENERAL_COMPUTER_TYPE("GENERAL_COMPUTER_TYPE", KeyGroup.GENERAL),
        GENERAL_LAST_RECOMMENDATION_RUN_TIME("GENERAL_LAST_RECOMMENDATION_RUN_TIME", KeyGroup.GENERAL),
        GENERAL_LAST_AGENT_COMMUNICATION("GENERAL_LAST_AGENT_COMMUNICATION", KeyGroup.GENERAL),
        GENERAL_AGENT_OFFLINE("GENERAL_AGENT_OFFLINE", KeyGroup.GENERAL),
        GENERAL_HOST_CREATION_TIME("GENERAL_HOST_CREATION_TIME", KeyGroup.GENERAL),
        GENERAL_HOST_TASKS("GENERAL_HOST_TASKS", KeyGroup.GENERAL),
        GENERAL_AGENT_VERSION("GENERAL_AGENT_VERSION", KeyGroup.GENERAL),
        AWS_TAG("AWS_TAG", KeyGroup.AWS),
        AWS_SECURITY_GROUP("AWS_SECURITY_GROUP", KeyGroup.AWS),
        AWS_SECURITY_GROUP_ID("AWS_SECURITY_GROUP_ID", KeyGroup.AWS),
        AWS_AMI_ID("AWS_AMI_ID", KeyGroup.AWS),
        AWS_ACCOUNT_ID("AWS_ACCOUNT_ID", KeyGroup.AWS),
        AWS_ACCOUNT_ALIAS("AWS_ACCOUNT_ALIAS", KeyGroup.AWS),
        AWS_REGION_ID("AWS_REGION_ID", KeyGroup.AWS),
        AWS_REGION_NAME("AWS_REGION_NAME", KeyGroup.AWS),
        AWS_VPC_ID("AWS_VPC_ID", KeyGroup.AWS),
        AWS_SUBNET_ID("AWS_SUBNET_ID", KeyGroup.AWS),
        AWS_DIRECTORY_ID("AWS_DIRECTORY_ID", KeyGroup.AWS),
        AZURE_SUBSCRIPTION_NAME("AZURE_SUBSCRIPTION_NAME", KeyGroup.AZURE),
        AZURE_RESOURCE_GROUP("AZURE_RESOURCE_GROUP", KeyGroup.AZURE),
        AZURE_LOCATION("AZURE_LOCATION", KeyGroup.AZURE),
        GCP_LABEL("GCP_LABEL", KeyGroup.GCP),
        GCP_NETWORK_TAG("GCP_NETWORK_TAG", KeyGroup.GCP),
        VCENTER_NAME("VCENTER_NAME", KeyGroup.VCENTER),
        VCENTER_DATACENTER("VCENTER_DATACENTER", KeyGroup.VCENTER),
        VCENTER_FOLDER("VCENTER_FOLDER", KeyGroup.VCENTER),
        VCENTER_ESX_HOST("VCENTER_ESX_HOST", KeyGroup.VCENTER),
        VCENTER_CUSTOM_ATTRIBUTE("VCENTER_CUSTOM_ATTRIBUTE", KeyGroup.VCENTER),
        VCLOUD_NAME("VCLOUD_NAME", KeyGroup.VCLOUD),
        VCLOUD_DATACENTER("VCLOUD_DATACENTER", KeyGroup.VCLOUD),
        VCLOUD_APPLICATION("VCLOUD_APPLICATION", KeyGroup.VCLOUD),
        DIRECTORY_NAME("DIRECTORY_NAME", KeyGroup.ACTIVE_DIRECTORY),
        DIRECTORY_FOLDER("DIRECTORY_FOLDER", KeyGroup.ACTIVE_DIRECTORY);

        private KeyGroup keyGroup;
        private static final Key[] copyOfKeys;
        private final String text;

        public static Key getKeyFromString(String string) {
            for (Key key : copyOfKeys) {
                if (!key.name().equals(string)) continue;
                return key;
            }
            return null;
        }

        private Key(String text, KeyGroup keyGroup) {
            this.text = text;
            this.keyGroup = keyGroup;
        }

        public KeyGroup getKeyGroup() {
            return this.keyGroup;
        }

        public String toString() {
            return this.text;
        }

        static {
            copyOfKeys = Key.values();
        }
    }

    public static enum Comparison {
        AND("AND"),
        OR("OR");

        private final String text;

        private Comparison(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum Operator {
        EQUALS("EQUALS"),
        NOT_EQUALS("NOT_EQUALS"),
        CONTAINS("CONTAINS"),
        DOES_NOT_CONTAIN("DOES_NOT_CONTAIN"),
        ANY_VALUE("ANY_VALUE"),
        IN_RANGE("IN_RANGE"),
        NOT_IN_RANGE("NOT_IN_RANGE"),
        OLDER_THAN("OLDER_THAN"),
        MORE_RECENTLY_THAN("MORE_RECENTLY_THAN"),
        NEVER("NEVER"),
        BEFORE("BEFORE"),
        AFTER("AFTER"),
        VERSION_OLDER_THAN("VERSION_OLDER_THAN"),
        VERSION_OLDER_THAN_OR_EQUAL_TO("VERSION_OLDER_THAN_OR_EQUAL_TO"),
        VERSION_NEWER_THAN("VERSION_NEWER_THAN"),
        VERSION_NEWER_THAN_OR_EQUAL_TO("VERSION_NEWER_THAN_OR_EQUAL_TO");

        private final String text;

        private Operator(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

