/*
 * Decompiled with CFR 0.152.
 */
package com.trendmicro.ds.platform.rest.object.scheduledtask;

import com.trendmicro.ds.platform.rest.object.scheduledtask.DailyScheduleParameters;
import com.trendmicro.ds.platform.rest.object.scheduledtask.IScheduleParameters;
import com.trendmicro.ds.platform.rest.object.scheduledtask.MonthlyScheduleParameters;
import com.trendmicro.ds.platform.rest.object.scheduledtask.WeeklyScheduleParameters;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Schedule")
public class Schedule {
    private Long startTime;
    private RecurrenceType recurrenceType;
    private Integer recurrenceCount;
    private IScheduleParameters scheduleParameters;

    @XmlElement(required=false)
    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Schedule withStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    public Schedule withStartTime(Date startTime) {
        this.startTime = startTime == null ? null : Long.valueOf(startTime.getTime());
        return this;
    }

    @XmlElement(required=false)
    public RecurrenceType getRecurrenceType() {
        return this.recurrenceType;
    }

    public void setRecurrenceType(RecurrenceType recurrenceType) {
        this.recurrenceType = recurrenceType;
    }

    public Schedule withRecurrenceType(RecurrenceType recurrenceType) {
        this.recurrenceType = recurrenceType;
        return this;
    }

    @XmlElement(required=false)
    public Integer getRecurrenceCount() {
        return this.recurrenceCount;
    }

    public void setRecurrenceCount(Integer recurrenceCount) {
        this.recurrenceCount = recurrenceCount;
    }

    public Schedule withRecurrenceCount(Integer recurrenceCount) {
        this.recurrenceCount = recurrenceCount;
        return this;
    }

    @XmlElement(required=false)
    public DailyScheduleParameters getDailyScheduleParameters() {
        if (this.scheduleParameters != null && this.scheduleParameters instanceof DailyScheduleParameters) {
            return (DailyScheduleParameters)this.scheduleParameters;
        }
        return null;
    }

    public void setDailyScheduleParameters(DailyScheduleParameters dailyScheduleParameters) {
        this.scheduleParameters = dailyScheduleParameters;
    }

    public Schedule withDailyScheduleParameters(DailyScheduleParameters dailyScheduleParameters) {
        this.scheduleParameters = dailyScheduleParameters;
        return this;
    }

    @XmlElement(required=false)
    public WeeklyScheduleParameters getWeeklyScheduleParameters() {
        if (this.scheduleParameters != null && this.scheduleParameters instanceof WeeklyScheduleParameters) {
            return (WeeklyScheduleParameters)this.scheduleParameters;
        }
        return null;
    }

    public void setWeeklyScheduleParameters(WeeklyScheduleParameters weeklyScheduleParameters) {
        this.scheduleParameters = weeklyScheduleParameters;
    }

    public Schedule withWeeklyScheduleParameters(WeeklyScheduleParameters weeklyScheduleParameters) {
        this.scheduleParameters = weeklyScheduleParameters;
        return this;
    }

    @XmlElement(required=false)
    public MonthlyScheduleParameters getMonthlyScheduleParameters() {
        if (this.scheduleParameters != null && this.scheduleParameters instanceof MonthlyScheduleParameters) {
            return (MonthlyScheduleParameters)this.scheduleParameters;
        }
        return null;
    }

    public void setMonthlyScheduleParameters(MonthlyScheduleParameters monthlyScheduleParameters) {
        this.scheduleParameters = monthlyScheduleParameters;
    }

    public Schedule withMonthlyScheduleParameters(MonthlyScheduleParameters monthlyScheduleParameters) {
        this.scheduleParameters = monthlyScheduleParameters;
        return this;
    }

    public Schedule withScheduleParameters(IScheduleParameters scheduleParameters) {
        this.scheduleParameters = scheduleParameters;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Schedule\n");
        builder.append("startTime = ");
        builder.append(this.startTime);
        builder.append("\n");
        builder.append("recurrenceType = ");
        builder.append((Object)this.recurrenceType);
        builder.append("\n");
        builder.append("recurrenceCount = ");
        builder.append(this.recurrenceCount);
        builder.append("\n");
        builder.append("scheduleParameters = ");
        builder.append(this.scheduleParameters == null ? "null" : this.scheduleParameters.toString());
        return builder.toString();
    }

    @XmlEnum
    public static enum RecurrenceType {
        NONE(5),
        HOURLY(1),
        DAILY(2),
        WEEKLY(3),
        MONTHLY(4);

        private final int value;

        private RecurrenceType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static RecurrenceType forValue(int value) {
            for (RecurrenceType t : RecurrenceType.values()) {
                if (t.value != value) continue;
                return t;
            }
            throw new IllegalArgumentException("Recurrence: " + value);
        }
    }
}

