/*
 * Decompiled with CFR 0.152.
 */
package com.trendmicro.ds.platform.rest.object;

import com.trendmicro.ds.platform.rest.object.Action;
import com.trendmicro.ds.platform.rest.object.Condition;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="EventBasedTask")
public class EventBasedTask {
    private Integer id;
    private String name;
    private EventType type;
    private boolean enabled = true;
    private List<Condition> conditions;
    private List<Action> actions;

    @XmlElement(required=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public EventBasedTask withId(Integer id) {
        this.id = id;
        return this;
    }

    @XmlElement(required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EventBasedTask withName(String name) {
        this.name = name;
        return this;
    }

    @XmlElement(required=true)
    public EventType getType() {
        return this.type;
    }

    public void setType(EventType type) {
        this.type = type;
    }

    public EventBasedTask withType(EventType type) {
        this.type = type;
        return this;
    }

    @XmlElement(required=false, defaultValue="true")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public EventBasedTask withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public EventBasedTask disable() {
        this.enabled = false;
        return this;
    }

    public EventBasedTask enable() {
        this.enabled = true;
        return this;
    }

    @XmlElement(required=false)
    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public EventBasedTask withConditions(List<Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public EventBasedTask withConditions(Condition ... conditions) {
        this.conditions = Arrays.asList(conditions);
        return this;
    }

    @XmlElement(required=false)
    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public EventBasedTask withActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    public EventBasedTask withActions(Action ... actions) {
        this.actions = Arrays.asList(actions);
        return this;
    }

    @XmlEnum
    public static enum EventType {
        COMPUTER_CREATED_BY_SYSTEM("computer-created-by-system", 1001),
        COMPUTER_MOVED_BY_SYSTEM("computer-moved-by-system", 1002),
        AGENT_INITIATED_ACTIVATION("agent-initiated-activation", 1003),
        AGENT_IP_CHANGED("agent-ip-changed", 1004),
        NSX_PROTECTION_CHANGED("nsx-protection-changed", 1005),
        COMPUTER_POWERED_ON_BY_SYSTEM("computer-powered-on-by-system", 1006);

        private final String value;
        private final int intValue;

        private EventType(String value, int intValue) {
            this.value = value;
            this.intValue = intValue;
        }

        public String getValue() {
            return this.value;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static EventType fromValue(String value) {
            for (EventType e : EventType.values()) {
                if (!e.value.equals(value)) continue;
                return e;
            }
            throw new IllegalArgumentException(value.toString());
        }

        public static EventType fromValue(int value) {
            for (EventType e : EventType.values()) {
                if (e.intValue != value) continue;
                return e;
            }
            throw new IllegalArgumentException(String.valueOf(value));
        }
    }
}

