/*
 * Decompiled with CFR 0.152.
 */
package com.trendmicro.ds.appcontrol.rest.object.drift;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Histogram {
    private List<Bucket> buckets;
    private Long total;

    public Histogram() {
        this(new ArrayList<Bucket>());
    }

    public Histogram(List<Bucket> buckets) {
        this.buckets = buckets;
    }

    public Histogram(Bucket ... buckets) {
        this.buckets = new ArrayList<Bucket>(Arrays.asList(buckets));
    }

    public void add(Bucket toAdd) {
        if (this.buckets == null) {
            this.buckets = new ArrayList<Bucket>();
        }
        this.buckets.add(toAdd);
    }

    public void add(Bucket ... toAdd) {
        if (this.buckets == null) {
            this.buckets = new ArrayList<Bucket>();
        }
        this.buckets.addAll(Arrays.asList(toAdd));
    }

    public void add(long time, long count) {
        this.add(new Bucket(time, count));
    }

    @XmlElement(required=true)
    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(List<Bucket> buckets) {
        this.buckets = buckets;
    }

    @XmlElement(required=true)
    public Long getTotal() {
        return this.total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public static class Bucket {
        private long time;
        private long count;

        public Bucket() {
        }

        public Bucket(long time, long count) {
            this.time = time;
            this.count = count;
        }

        @XmlElement(required=true)
        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        @XmlElement(required=true)
        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }
    }
}

