/*
 * Decompiled with CFR 0.152.
 */
package com.trendmicro.ds.platform.rest.object.scheduledtask;

import com.trendmicro.ds.platform.rest.object.scheduledtask.IScheduleParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="MonthlyScheduleParameters")
public class MonthlyScheduleParameters
implements IScheduleParameters {
    public static final Month[] ALL_MONTHS = new Month[]{Month.JANUARY, Month.FEBRUARY, Month.MARCH, Month.APRIL, Month.MAY, Month.JUNE, Month.JULY, Month.AUGUST, Month.SEPTEMBER, Month.OCTOBER, Month.NOVEMBER, Month.DECEMBER};
    private FrequencyType frequencyType;
    private Integer dayOfMonth;
    private Week weekOfMonth;
    private Day dayOfWeek;
    private List<Month> months = new ArrayList<Month>();

    @XmlElement(required=false)
    public FrequencyType getFrequencyType() {
        return this.frequencyType;
    }

    public void setFrequencyType(FrequencyType frequencyType) {
        this.frequencyType = frequencyType;
    }

    public MonthlyScheduleParameters withFrequency(FrequencyType frequencyType) {
        this.frequencyType = frequencyType;
        return this;
    }

    @XmlElement(required=false)
    public Integer getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public MonthlyScheduleParameters withDayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        return this;
    }

    @XmlElement(required=false)
    public Week getWeekOfMonth() {
        return this.weekOfMonth;
    }

    public void setWeekOfMonth(Week weekOfMonth) {
        this.weekOfMonth = weekOfMonth;
    }

    public MonthlyScheduleParameters withWeekOfMonth(Week weekOfMonth) {
        this.weekOfMonth = weekOfMonth;
        return this;
    }

    @XmlElement(required=false)
    public Day getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(Day dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public MonthlyScheduleParameters withDayOfWeek(Day dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    @XmlElement(required=false)
    public List<Month> getMonths() {
        return this.months;
    }

    public void setMonths(List<Month> months) {
        this.months = months;
    }

    public MonthlyScheduleParameters withMonths(List<Month> months) {
        this.months = months;
        return this;
    }

    public MonthlyScheduleParameters withMonths(Month ... months) {
        this.months = Arrays.asList(months);
        return this;
    }

    public MonthlyScheduleParameters addMonth(Month month) {
        this.months.add(month);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MonthlyScheduleParameters\n");
        builder.append("frequencyType = ");
        builder.append((Object)this.frequencyType);
        builder.append("\n");
        builder.append("dayOfMonth = ");
        builder.append(this.dayOfMonth);
        builder.append("\n");
        builder.append("weekOfMonth = ");
        builder.append((Object)this.weekOfMonth);
        builder.append("\n");
        builder.append("dayOfWeek = ");
        builder.append((Object)this.dayOfWeek);
        builder.append("\n");
        builder.append("months = ");
        builder.append(this.months);
        return builder.toString();
    }

    @XmlEnum
    public static enum Month {
        JANUARY(0),
        FEBRUARY(1),
        MARCH(2),
        APRIL(3),
        MAY(4),
        JUNE(5),
        JULY(6),
        AUGUST(7),
        SEPTEMBER(8),
        OCTOBER(9),
        NOVEMBER(10),
        DECEMBER(11);

        private final int value;

        private Month(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Month forValue(int value) {
            for (Month t : Month.values()) {
                if (t.value != value) continue;
                return t;
            }
            throw new IllegalArgumentException("Month: " + value);
        }
    }

    @XmlEnum
    public static enum Week {
        FIRST(1),
        SECOND(2),
        THIRD(3),
        FOURTH(4),
        LAST(5);

        private final int value;

        private Week(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Week forValue(int value) {
            for (Week t : Week.values()) {
                if (t.value != value) continue;
                return t;
            }
            throw new IllegalArgumentException("Week: " + value);
        }
    }

    @XmlEnum
    public static enum Day {
        SUNDAY(1),
        MONDAY(2),
        TUESDAY(3),
        WEDNESDAY(4),
        THURSDAY(5),
        FRIDAY(6),
        SATURDAY(7);

        private final int value;

        private Day(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Day forValue(int value) {
            for (Day t : Day.values()) {
                if (t.value != value) continue;
                return t;
            }
            throw new IllegalArgumentException("Day: " + value);
        }
    }

    @XmlEnum
    public static enum FrequencyType {
        DAY_OF_MONTH(0),
        LAST_DAY_OF_MONTH(2),
        CUSTOM(1);

        private final int value;

        private FrequencyType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static FrequencyType forValue(int value) {
            for (FrequencyType t : FrequencyType.values()) {
                if (t.value != value) continue;
                return t;
            }
            throw new IllegalArgumentException("Type: " + value);
        }
    }
}

