/*
 * Decompiled with CFR 0.152.
 */
package com.trendmicro.ds.appcontrol.rest.object.drift;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="ListApplicationDriftResponse")
public class ListApplicationDriftResponse {
    private int total;
    private boolean countOverMaximum;
    private List<Item> items = new ArrayList<Item>();

    public ListApplicationDriftResponse() {
    }

    public ListApplicationDriftResponse(int total, List<Item> items) {
        this.total = total;
        this.items = items;
    }

    public ListApplicationDriftResponse(int total, Item ... items) {
        this.total = total;
        this.items = new ArrayList<Item>(Arrays.asList(items));
    }

    public void add(Item ... toAdd) {
        if (this.items == null) {
            this.items = new ArrayList<Item>();
        }
        this.items.addAll(Arrays.asList(toAdd));
    }

    @XmlElement(required=true)
    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public ListApplicationDriftResponse withItems(List<Item> items) {
        this.items = items;
        return this;
    }

    @XmlElement(required=true)
    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public ListApplicationDriftResponse withTotal(int total) {
        this.total = total;
        return this;
    }

    @XmlElement(defaultValue="false")
    public boolean getCountOverMaximum() {
        return this.countOverMaximum;
    }

    public void setCountOverMaximum(boolean countOverMaximum) {
        this.countOverMaximum = countOverMaximum;
    }

    public static class Item
    implements Comparable<Item> {
        private String sha256;
        private Set<String> fileNames;
        private long count;

        public Item() {
        }

        public Item(String sha256, Set<String> fileNames, long count) {
            this.sha256 = sha256;
            this.fileNames = fileNames;
            this.count = count;
        }

        @XmlElement
        public String getSha256() {
            return this.sha256;
        }

        public void setSha256(String sha256) {
            this.sha256 = sha256;
        }

        @XmlElement
        public Set<String> getFileNames() {
            return this.fileNames;
        }

        public void setFileNames(Set<String> fileNames) {
            this.fileNames = fileNames;
        }

        @XmlElement
        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public void addFileName(String fileName, long numInstances) {
            if (this.fileNames == null) {
                this.fileNames = new LinkedHashSet<String>();
            }
            this.fileNames.add(fileName);
            this.count += numInstances;
        }

        @Override
        public int compareTo(Item o) {
            return Long.valueOf(this.count).compareTo(o.getCount());
        }
    }
}

