# Application Control
You can learn more about application control from the [Deep Security Help Center](https://help.deepsecurity.trendmicro.com/Protection-Modules/Application-Control/app-control.html).

## Application control concepts

### Rulesets
A ruleset is a list of rules. Each rule identifies an application by:
* **hash**, which is the SHA-256 hash of the file contents
* **filename**, including the full path to the file
* **size**

When an application is being checked against a rule, all three attributes must match for the rule to match.

Each rule has an action, either `allow` or `block`, which tells the Deep Security Agent what action to take when the application is launched.

You can create rulesets by uploading them through the API or, more conveniently, by performing a baseline inventory scan of a computer and converting the inventory into a ruleset.

### Enforcement
You can configure application control to:
* block unrecognized software until it is explicitly allowed, or
* allow unrecognized software until it is explicitly blocked

The first mode is more restrictive and provides active protection. The second mode is more permissive and is appropriate for monitoring.

### Auto-Authorization
Auto-authorization is a mechanism for automatically approving updates. You can enable auto-authorization mode, perform your updates, and have the updates automatically reflected in your ruleset.

## Authentication and authorization
You must include a session identifier in all API requests to the Deep Security Manager. First, authenticate with the Deep Security Manager to obtain a session ID and then include the session ID in a cookie parameter called `sID` when you make your requests.

### API endpoint
```
POST /rest/authentication/login
```

### Example request body
```json
{ "dsCredentials": {
   "userName": "apiuser",
   "password": "****************",
 }
}
```

## Turn on application control

The first step in the process is turning on application control. To do this, you need to modify the application control policy parameters in the policy assigned to your computer.

If you want to turn off application control, change `on` to `off` in the request.

### API endpoint
```
POST /rest/policies/{id}/application-control
```

### Example request body
```json
{ "ModifyApplicationControlPolicyRequest": {
    "appControlPolicyParameters": {
      "state": "on",
    }
  }
}
```

See also: `EnableAppControl.java`.

## Perform an inventory scan on a computer
When you turn on application control on a computer, the Deep Security Agent will automatically perform an inventory scan and create a local ruleset for use on that computer. This will be enough for most basic protection scenarios.

However, if you have a dynamic environment where instances are created from an image on demand, you can get protection faster by creating a shared ruleset, assigning that shared ruleset to a policy, and assigning that policy to instances as they are created.

Shared rulesets are only meant for use on instances that are **exact** copies of each other, such as instances in an auto-scaling group. If you use a shared ruleset on a computer that is not an exact copy of the computer where the ruleset was created, applications that are not in the ruleset will be blocked or create security events.

The first step in building a shared ruleset is performing an  inventory scan of an instance running the image.

### API endpoint
```
POST /rest/software-inventory
```

### Example request body
```json
{ "CreateInventoryRequest": {
    "hostID": 1,
    "name": "APP01-Webserver-v1.0.0",
    "description": "Inventory of APP01-WebServer version 1.0.0"
  }
}
```

### Example response body
```json
{ "CreateInventoryResponse": {
    "inventoryID": 1
  }
}
```

See also: `BuildInventory.java`.

## Retrieve inventory details
Sometimes you want to know all of the applications Deep Security has found on a host, either for auditing / compliance purposes or just to keep as an offline record. Once you've completed an inventory scan on a computer, you can retrieve the detailed list of applications found.

### API endpoint
```
GET /rest/software-inventory/{id}/details
```

### Example response body
```json
{ "GetInventoryResponse": {
    "inventoryItems": [
      {
        "category": "...",
        "fileDescription": "...",
        "fileName": "...",
        "fileVersion": "...",
        "md5": "...",
        "path": "...",
        "productName": "...",
        "productVersion": "...",
        "sha1": "...",
        "sha256": "...",
        "size": 123,
        "vendorName": "..."
      },
      ...
    ]
  }
}
```

**NOTE:** depending on the file and our ability to retrieve data from the package management system on the host, you may or may not get all of the fields shown above, or the field contents may be empty. However, you will be able to count on `path`,  `fileName`, `size`, and the three hash values `sha256`, `sha1`, and `md5`.

See also: `GetInventory.java`.

## Convert the baseline inventory into a shared ruleset
Once you've completed a baseline inventory scan on an instance, you can create a shared ruleset. You can then use the shared ruleset in a policy and apply it to other computers that are using the same image.

Remember: Shared rulesets are only meant for use on instances that are **exact** copies of each other, such as instances in an auto-scaling group. If you use a shared ruleset on a computer that is not an exact copy of the computer where the ruleset was created, applications that are not in the ruleset will be blocked or create security events.

### API endpoint
```
POST /rest/rulesets
```

### Example request body
```json
{ "CreateRulesetRequest": {
    "inventoryID": 123
  }
}
```

### Example response body
```json
{ "CreateRulesetResponse": {
    "rulesetID": 456
  }
}
```

See also: `CreateRuleset.java`.

## Use a shared ruleset in a policy
Once you've created a shared ruleset, you can use it in a policy by setting the application control parameters in the policy.

### API endpoint
```
POST /rest/policies/{id}/application-control
```

### Example request body
```json
{ "ModifyApplicationControlPolicyRequest": {
    "appControlPolicyParameters": {
      "state": "on",
      "whitelistMode": "shared",
      "rulesetID": 456,
      "lockdown": false
    }
  }
}
```

See also: `ApplyRuleset.java`.

## Set up an event-based task to assign policy
While not strictly an application-control-related topic, it's the last logical step in enabling application control for elastic workloads, so here we go.

You've got your shared ruleset based on the inventory of an instance. You've built a policy that you want to use, and it's got application control turned on using the shared ruleset. Now, let's set up an event-based task so that the policy will get auto-assigned to new instances in your auto-scaling group.

### API endpoint
```
POST /rest/tasks/event-based
```

### Example request body
```json
{ "CreateEventBasedTaskRequest": {
    "task": {
      "name": "AssignPolicy",
      "type": "agent-initiated-activation",
      "conditions": [{
        "field": "cloudInstanceMetadata",
        "key": "sampleTagName",
        "value": "sampleTagValue"
      }],
      "actions": [{
        "type": "assign-policy",
        "parameterValue": 789
      }],
      "enabled": true
    }
  }
}
```

This will assign policy `789` to newly-activated computers with the AWS tag `sampleTagName` set to `sampleTagValue`.

### Example response body
```json
{ "CreateEventBasedTaskResponse": {
    "taskID": 1
  }
}
```

See also: `CreateEventBasedTask.java`.

## Turn on auto-authorization mode

If you're not running immutable infrastructure, from time to time you will need to add new applications or update the applications on computers protected with application control.

You can automatically authorize updates or new applications installed on the computer by first putting the computer into "auto-authorization mode". When the computer is in this mode, any new or updated applications will automatically get added to to the ruleset and will be allowed to run.

You can set auto-authorization mode to stay on indefinitely, or you can set a failsafe timer to ensure that protection reverts to normal operation automatically even if your update process fails.

When your update process completes, you can turn off auto-authorization mode by sending `"enabled": false` instead of `"enabled": true` in the example below. This will turn off auto-authorization mode and cancel the failsafe timer.

**Important note:** The Deep Security solution is asynchronous. Your request to enable auto-authorization mode may take some time to take effect on the computer. To avoid problems, you should wait for auto-authorization mode to be active on the computer before you start making changes. When you see `on` in the `DescribeTrustedUpdateModeResponse` (below), the Deep Security Agent has acknowledged the request and auto-authorization mode is active.

### API endpoint (modify)
```
POST /hosts/{id}/trusted-update-mode
```

### Example request body
```json
{ "ModifyTrustedUpdateModeRequest": {
    "enabled": true,
    "duration": 15
  }
}
```

This will turn on auto-authorization mode with a failsafe timer set to 15 minutes.

### API endpoint (retrieve)
```
GET /hosts/{id}/trusted-update-mode
```

### Example response body
```json
{ "DescribeTrustedUpdateModeResponse": {
    "state": "on",
    "endTime": 1491019200000
  }
}
```

See also: `ModifyAutoAuthorizationMode.java`.
