/*
 * Decompiled with CFR 0.152.
 */
package com.trendmicro.ds.platform.rest.object.smartfolder;

import com.trendmicro.ds.platform.rest.object.smartfolder.Model;
import com.trendmicro.ds.platform.rest.object.smartfolder.ParentSmartFolderSummary;
import com.trendmicro.ds.platform.rest.object.smartfolder.QueryGroup;
import com.trendmicro.ds.platform.rest.object.smartfolder.SmartFolderSummary;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="SmartFolder")
public class SmartFolder {
    private Long smartFolderId;
    private String name;
    private Long parentSmartFolderId;
    private List<SmartFolderSummary> childSmartFolders = new ArrayList<SmartFolderSummary>();
    private List<ParentSmartFolderSummary> parentSmartFolders = new ArrayList<ParentSmartFolderSummary>();
    private Integer type;
    private List<QueryGroup> queryGroups;
    private String awsTagFoldersNameKey;
    private Model.Comparison comparison;

    @XmlElement(required=true)
    public Long getSmartFolderId() {
        return this.smartFolderId;
    }

    public void setSmartFolderId(Long smartFolderId) {
        this.smartFolderId = smartFolderId;
    }

    public SmartFolder withSmartFolderId(Long smartFolderId) {
        this.smartFolderId = smartFolderId;
        return this;
    }

    @XmlElement(required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SmartFolder withName(String name) {
        this.name = name;
        return this;
    }

    @XmlElement(required=false)
    public Long getParentSmartFolderId() {
        return this.parentSmartFolderId;
    }

    public void setParentSmartFolderId(Long parentSmartFolderId) {
        this.parentSmartFolderId = parentSmartFolderId;
    }

    public SmartFolder withParentSmartFolderId(Long parentSmartFolderId) {
        this.parentSmartFolderId = parentSmartFolderId;
        return this;
    }

    @XmlElement(required=true)
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public SmartFolder withType(Integer type) {
        this.type = type;
        return this;
    }

    @XmlElement(required=false)
    public List<SmartFolderSummary> getChildSmartFolders() {
        if (this.childSmartFolders == null) {
            return new ArrayList<SmartFolderSummary>();
        }
        return this.childSmartFolders;
    }

    public void setSmartFolders(List<SmartFolderSummary> childSmartFolders) {
        this.childSmartFolders = childSmartFolders;
    }

    public SmartFolder withChildSmartFolders(List<SmartFolderSummary> childSmartFolders) {
        this.childSmartFolders = childSmartFolders;
        return this;
    }

    public void addSmartFolder(SmartFolderSummary childSmartFolder) {
        if (this.childSmartFolders == null) {
            this.childSmartFolders = new ArrayList<SmartFolderSummary>();
        }
        this.childSmartFolders.add(childSmartFolder);
    }

    @XmlElement(required=true)
    public List<QueryGroup> getQueryGroups() {
        return this.queryGroups;
    }

    public void setQueryGroups(List<QueryGroup> queryGroups) {
        this.queryGroups = queryGroups;
    }

    public SmartFolder withQueryGroups(List<QueryGroup> queryGroups) {
        this.queryGroups = queryGroups;
        return this;
    }

    @XmlElement(required=true)
    public Model.Comparison getComparison() {
        return this.comparison;
    }

    public void setComparison(Model.Comparison comparison) {
        this.comparison = comparison;
    }

    public SmartFolder withComparison(Model.Comparison comparison) {
        this.comparison = comparison;
        return this;
    }

    @XmlElement(required=false)
    public String getAwsTagFoldersNameKey() {
        return this.awsTagFoldersNameKey;
    }

    public void setAwsTagFoldersNameKey(String awsTagFoldersNameKey) {
        this.awsTagFoldersNameKey = awsTagFoldersNameKey;
    }

    public SmartFolder withAwsTagFoldersNameKey(String awsTagFoldersNameKey) {
        this.awsTagFoldersNameKey = awsTagFoldersNameKey;
        return this;
    }

    @XmlElement(required=false)
    public List<ParentSmartFolderSummary> getParentSmartFolders() {
        return this.parentSmartFolders;
    }

    public void setParentSmartFolders(List<ParentSmartFolderSummary> parentSmartFolders) {
        this.parentSmartFolders = parentSmartFolders;
    }

    public SmartFolder withParentSmartFolders(List<ParentSmartFolderSummary> parentSmartFolders) {
        this.parentSmartFolders = parentSmartFolders;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ID: ");
        builder.append(this.getSmartFolderId());
        builder.append(", ");
        builder.append("Name: ");
        builder.append(this.getName());
        builder.append(", ");
        builder.append("Type: ");
        switch (this.getType()) {
            case 1: {
                builder.append("Standard");
                break;
            }
            case 2: {
                builder.append("AWS tag");
                break;
            }
            case 3: {
                builder.append("AWS tag child");
                break;
            }
            default: {
                builder.append("Unknown");
            }
        }
        builder.append(", ");
        builder.append("AWS-Tag-Key: ");
        builder.append(this.getAwsTagFoldersNameKey());
        builder.append(", ");
        builder.append("Group-Comparison: ");
        builder.append((Object)this.getComparison());
        builder.append(", ");
        builder.append("Parent: ");
        builder.append(this.getParentSmartFolderId());
        builder.append("\r\nQuery-Groups:\r\n");
        if (this.getQueryGroups() != null) {
            for (QueryGroup group : this.getQueryGroups()) {
                builder.append(group.toString());
                builder.append("\r\n");
            }
        }
        return builder.toString();
    }
}

