/*
 * Decompiled with CFR 0.152.
 */
package com.trendmicro.ds.platform.rest.object.scheduledtask;

import com.trendmicro.ds.platform.rest.object.scheduledtask.IScheduleParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="WeeklyScheduleParameters")
public class WeeklyScheduleParameters
implements IScheduleParameters {
    private Integer interval = 1;
    private List<Day> days = new ArrayList<Day>();

    @XmlElement(required=false)
    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public WeeklyScheduleParameters withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    @XmlElement(required=false)
    public List<Day> getDays() {
        return this.days;
    }

    public void setDays(List<Day> days) {
        this.days = days;
    }

    public WeeklyScheduleParameters withDays(List<Day> days) {
        this.days = days;
        return this;
    }

    public WeeklyScheduleParameters withDays(Day ... days) {
        this.days = Arrays.asList(days);
        return this;
    }

    public WeeklyScheduleParameters addDay(Day day) {
        this.days.add(day);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WeeklyScheduleParameters\n");
        builder.append("interval = ");
        builder.append(this.interval);
        builder.append("\n");
        builder.append("days = ");
        builder.append(this.days);
        return builder.toString();
    }

    @XmlEnum
    public static enum Day {
        SUNDAY(0),
        MONDAY(1),
        TUESDAY(2),
        WEDNESDAY(3),
        THURSDAY(4),
        FRIDAY(5),
        SATURDAY(6);

        private final int value;

        private Day(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Day forValue(int value) {
            for (Day t : Day.values()) {
                if (t.value != value) continue;
                return t;
            }
            throw new IllegalArgumentException("Day: " + value);
        }
    }
}

