/*
 * Decompiled with CFR 0.152.
 */
package com.trendmicro.ds.platform.rest.object.scheduledtask;

import com.trendmicro.ds.platform.rest.object.scheduledtask.DailyScheduleParameters;
import com.trendmicro.ds.platform.rest.object.scheduledtask.IScheduleParameters;
import com.trendmicro.ds.platform.rest.object.scheduledtask.MonthlyScheduleParameters;
import com.trendmicro.ds.platform.rest.object.scheduledtask.WeeklyScheduleParameters;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Schedule")
public class Schedule {
    private Long startTime;
    private RecurrenceType recurrenceType;
    private Integer recurrenceCount;
    private IScheduleParameters scheduleParameters;

    @XmlElement(required=false)
    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long l) {
        this.startTime = l;
    }

    public Schedule withStartTime(Long l) {
        this.startTime = l;
        return this;
    }

    public Schedule withStartTime(Date date) {
        this.startTime = date == null ? null : Long.valueOf(date.getTime());
        return this;
    }

    @XmlElement(required=false)
    public RecurrenceType getRecurrenceType() {
        return this.recurrenceType;
    }

    public void setRecurrenceType(RecurrenceType recurrenceType) {
        this.recurrenceType = recurrenceType;
    }

    public Schedule withRecurrenceType(RecurrenceType recurrenceType) {
        this.recurrenceType = recurrenceType;
        return this;
    }

    @XmlElement(required=false)
    public Integer getRecurrenceCount() {
        return this.recurrenceCount;
    }

    public void setRecurrenceCount(Integer n) {
        this.recurrenceCount = n;
    }

    public Schedule withRecurrenceCount(Integer n) {
        this.recurrenceCount = n;
        return this;
    }

    @XmlElement(required=false)
    public DailyScheduleParameters getDailyScheduleParameters() {
        if (this.scheduleParameters != null && this.scheduleParameters instanceof DailyScheduleParameters) {
            return (DailyScheduleParameters)this.scheduleParameters;
        }
        return null;
    }

    public void setDailyScheduleParameters(DailyScheduleParameters dailyScheduleParameters) {
        this.scheduleParameters = dailyScheduleParameters;
    }

    public Schedule withDailyScheduleParameters(DailyScheduleParameters dailyScheduleParameters) {
        this.scheduleParameters = dailyScheduleParameters;
        return this;
    }

    @XmlElement(required=false)
    public WeeklyScheduleParameters getWeeklyScheduleParameters() {
        if (this.scheduleParameters != null && this.scheduleParameters instanceof WeeklyScheduleParameters) {
            return (WeeklyScheduleParameters)this.scheduleParameters;
        }
        return null;
    }

    public void setWeeklyScheduleParameters(WeeklyScheduleParameters weeklyScheduleParameters) {
        this.scheduleParameters = weeklyScheduleParameters;
    }

    public Schedule withWeeklyScheduleParameters(WeeklyScheduleParameters weeklyScheduleParameters) {
        this.scheduleParameters = weeklyScheduleParameters;
        return this;
    }

    @XmlElement(required=false)
    public MonthlyScheduleParameters getMonthlyScheduleParameters() {
        if (this.scheduleParameters != null && this.scheduleParameters instanceof MonthlyScheduleParameters) {
            return (MonthlyScheduleParameters)this.scheduleParameters;
        }
        return null;
    }

    public void setMonthlyScheduleParameters(MonthlyScheduleParameters monthlyScheduleParameters) {
        this.scheduleParameters = monthlyScheduleParameters;
    }

    public Schedule withMonthlyScheduleParameters(MonthlyScheduleParameters monthlyScheduleParameters) {
        this.scheduleParameters = monthlyScheduleParameters;
        return this;
    }

    public Schedule withScheduleParameters(IScheduleParameters iScheduleParameters) {
        this.scheduleParameters = iScheduleParameters;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Schedule\n");
        stringBuilder.append("startTime = ");
        stringBuilder.append(this.startTime);
        stringBuilder.append("\n");
        stringBuilder.append("recurrenceType = ");
        stringBuilder.append((Object)this.recurrenceType);
        stringBuilder.append("\n");
        stringBuilder.append("recurrenceCount = ");
        stringBuilder.append(this.recurrenceCount);
        stringBuilder.append("\n");
        stringBuilder.append("scheduleParameters = ");
        stringBuilder.append(this.scheduleParameters == null ? "null" : this.scheduleParameters.toString());
        return stringBuilder.toString();
    }

    @XmlEnum
    public static enum RecurrenceType {
        NONE(5),
        HOURLY(1),
        DAILY(2),
        WEEKLY(3),
        MONTHLY(4);

        private final int value;

        private RecurrenceType(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        public static RecurrenceType forValue(int n) {
            for (RecurrenceType recurrenceType : RecurrenceType.values()) {
                if (recurrenceType.value != n) continue;
                return recurrenceType;
            }
            throw new IllegalArgumentException("Recurrence: " + n);
        }
    }
}

