/*
 * Decompiled with CFR 0.152.
 */
package com.trendmicro.ds.platform.rest.object.scheduledtask;

import com.trendmicro.ds.platform.rest.object.scheduledtask.IScheduleParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="MonthlyScheduleParameters")
public class MonthlyScheduleParameters
implements IScheduleParameters {
    public static final Month[] ALL_MONTHS = new Month[]{Month.JANUARY, Month.FEBRUARY, Month.MARCH, Month.APRIL, Month.MAY, Month.JUNE, Month.JULY, Month.AUGUST, Month.SEPTEMBER, Month.OCTOBER, Month.NOVEMBER, Month.DECEMBER};
    private FrequencyType frequencyType;
    private Integer dayOfMonth;
    private Week weekOfMonth;
    private Day dayOfWeek;
    private List<Month> months = new ArrayList<Month>();

    @XmlElement(required=false)
    public FrequencyType getFrequencyType() {
        return this.frequencyType;
    }

    public void setFrequencyType(FrequencyType frequencyType) {
        this.frequencyType = frequencyType;
    }

    public MonthlyScheduleParameters withFrequency(FrequencyType frequencyType) {
        this.frequencyType = frequencyType;
        return this;
    }

    @XmlElement(required=false)
    public Integer getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(Integer n) {
        this.dayOfMonth = n;
    }

    public MonthlyScheduleParameters withDayOfMonth(Integer n) {
        this.dayOfMonth = n;
        return this;
    }

    @XmlElement(required=false)
    public Week getWeekOfMonth() {
        return this.weekOfMonth;
    }

    public void setWeekOfMonth(Week week) {
        this.weekOfMonth = week;
    }

    public MonthlyScheduleParameters withWeekOfMonth(Week week) {
        this.weekOfMonth = week;
        return this;
    }

    @XmlElement(required=false)
    public Day getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(Day day) {
        this.dayOfWeek = day;
    }

    public MonthlyScheduleParameters withDayOfWeek(Day day) {
        this.dayOfWeek = day;
        return this;
    }

    @XmlElement(required=false)
    public List<Month> getMonths() {
        return this.months;
    }

    public void setMonths(List<Month> list) {
        this.months = list;
    }

    public MonthlyScheduleParameters withMonths(List<Month> list) {
        this.months = list;
        return this;
    }

    public MonthlyScheduleParameters withMonths(Month ... monthArray) {
        this.months = Arrays.asList(monthArray);
        return this;
    }

    public MonthlyScheduleParameters addMonth(Month month) {
        this.months.add(month);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MonthlyScheduleParameters\n");
        stringBuilder.append("frequencyType = ");
        stringBuilder.append((Object)this.frequencyType);
        stringBuilder.append("\n");
        stringBuilder.append("dayOfMonth = ");
        stringBuilder.append(this.dayOfMonth);
        stringBuilder.append("\n");
        stringBuilder.append("weekOfMonth = ");
        stringBuilder.append((Object)this.weekOfMonth);
        stringBuilder.append("\n");
        stringBuilder.append("dayOfWeek = ");
        stringBuilder.append((Object)this.dayOfWeek);
        stringBuilder.append("\n");
        stringBuilder.append("months = ");
        stringBuilder.append(this.months);
        return stringBuilder.toString();
    }

    @XmlEnum
    public static enum Month {
        JANUARY(0),
        FEBRUARY(1),
        MARCH(2),
        APRIL(3),
        MAY(4),
        JUNE(5),
        JULY(6),
        AUGUST(7),
        SEPTEMBER(8),
        OCTOBER(9),
        NOVEMBER(10),
        DECEMBER(11);

        private final int value;

        private Month(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        public static Month forValue(int n) {
            for (Month month : Month.values()) {
                if (month.value != n) continue;
                return month;
            }
            throw new IllegalArgumentException("Month: " + n);
        }
    }

    @XmlEnum
    public static enum Week {
        FIRST(1),
        SECOND(2),
        THIRD(3),
        FOURTH(4),
        LAST(5);

        private final int value;

        private Week(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        public static Week forValue(int n) {
            for (Week week : Week.values()) {
                if (week.value != n) continue;
                return week;
            }
            throw new IllegalArgumentException("Week: " + n);
        }
    }

    @XmlEnum
    public static enum Day {
        SUNDAY(1),
        MONDAY(2),
        TUESDAY(3),
        WEDNESDAY(4),
        THURSDAY(5),
        FRIDAY(6),
        SATURDAY(7);

        private final int value;

        private Day(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        public static Day forValue(int n) {
            for (Day day : Day.values()) {
                if (day.value != n) continue;
                return day;
            }
            throw new IllegalArgumentException("Day: " + n);
        }
    }

    @XmlEnum
    public static enum FrequencyType {
        DAY_OF_MONTH(0),
        LAST_DAY_OF_MONTH(2),
        CUSTOM(1);

        private final int value;

        private FrequencyType(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        public static FrequencyType forValue(int n) {
            for (FrequencyType frequencyType : FrequencyType.values()) {
                if (frequencyType.value != n) continue;
                return frequencyType;
            }
            throw new IllegalArgumentException("Type: " + n);
        }
    }
}

