/*
 * Decompiled with CFR 0.152.
 */
package com.trendmicro.ds.platform.rest.object;

import com.trendmicro.ds.platform.rest.object.Action;
import com.trendmicro.ds.platform.rest.object.Condition;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="EventBasedTask")
public class EventBasedTask {
    private Integer id;
    private String name;
    private EventType type;
    private boolean enabled = true;
    private List<Condition> conditions;
    private List<Action> actions;

    @XmlElement(required=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public EventBasedTask withId(Integer n) {
        this.id = n;
        return this;
    }

    @XmlElement(required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public EventBasedTask withName(String string) {
        this.name = string;
        return this;
    }

    @XmlElement(required=true)
    public EventType getType() {
        return this.type;
    }

    public void setType(EventType eventType) {
        this.type = eventType;
    }

    public EventBasedTask withType(EventType eventType) {
        this.type = eventType;
        return this;
    }

    @XmlElement(required=false, defaultValue="true")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public EventBasedTask withEnabled(boolean bl) {
        this.enabled = bl;
        return this;
    }

    public EventBasedTask disable() {
        this.enabled = false;
        return this;
    }

    public EventBasedTask enable() {
        this.enabled = true;
        return this;
    }

    @XmlElement(required=false)
    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> list) {
        this.conditions = list;
    }

    public EventBasedTask withConditions(List<Condition> list) {
        this.conditions = list;
        return this;
    }

    public EventBasedTask withConditions(Condition ... conditionArray) {
        this.conditions = Arrays.asList(conditionArray);
        return this;
    }

    @XmlElement(required=false)
    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> list) {
        this.actions = list;
    }

    public EventBasedTask withActions(List<Action> list) {
        this.actions = list;
        return this;
    }

    public EventBasedTask withActions(Action ... actionArray) {
        this.actions = Arrays.asList(actionArray);
        return this;
    }

    @XmlEnum
    public static enum EventType {
        COMPUTER_CREATED_BY_SYSTEM("computer-created-by-system", 1001),
        COMPUTER_MOVED_BY_SYSTEM("computer-moved-by-system", 1002),
        AGENT_INITIATED_ACTIVATION("agent-initiated-activation", 1003),
        AGENT_IP_CHANGED("agent-ip-changed", 1004),
        NSX_PROTECTION_CHANGED("nsx-protection-changed", 1005),
        COMPUTER_POWERED_ON_BY_SYSTEM("computer-powered-on-by-system", 1006);

        private final String value;
        private final int intValue;

        private EventType(String string2, int n2) {
            this.value = string2;
            this.intValue = n2;
        }

        public String getValue() {
            return this.value;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static EventType fromValue(String string) {
            for (EventType eventType : EventType.values()) {
                if (!eventType.value.equals(string)) continue;
                return eventType;
            }
            throw new IllegalArgumentException(string.toString());
        }

        public static EventType fromValue(int n) {
            for (EventType eventType : EventType.values()) {
                if (eventType.intValue != n) continue;
                return eventType;
            }
            throw new IllegalArgumentException(String.valueOf(n));
        }
    }
}

