/*
 * Decompiled with CFR 0.152.
 */
package com.trendmicro.ds.appcontrol.rest.object.drift;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="ListApplicationDriftResponse")
public class ListApplicationDriftResponse {
    private int total;
    private boolean countOverMaximum;
    private List<Item> items = new ArrayList<Item>();

    public ListApplicationDriftResponse() {
    }

    public ListApplicationDriftResponse(int n, List<Item> list) {
        this.total = n;
        this.items = list;
    }

    public ListApplicationDriftResponse(int n, Item ... itemArray) {
        this.total = n;
        this.items = new ArrayList<Item>(Arrays.asList(itemArray));
    }

    public void add(Item ... itemArray) {
        if (this.items == null) {
            this.items = new ArrayList<Item>();
        }
        this.items.addAll(Arrays.asList(itemArray));
    }

    @XmlElement(required=true)
    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> list) {
        this.items = list;
    }

    public ListApplicationDriftResponse withItems(List<Item> list) {
        this.items = list;
        return this;
    }

    @XmlElement(required=true)
    public int getTotal() {
        return this.total;
    }

    public void setTotal(int n) {
        this.total = n;
    }

    public ListApplicationDriftResponse withTotal(int n) {
        this.total = n;
        return this;
    }

    @XmlElement(defaultValue="false")
    public boolean getCountOverMaximum() {
        return this.countOverMaximum;
    }

    public void setCountOverMaximum(boolean bl) {
        this.countOverMaximum = bl;
    }

    public static class Item
    implements Comparable<Item> {
        private String sha256;
        private Set<String> fileNames;
        private long count;

        public Item() {
        }

        public Item(String string, Set<String> set, long l) {
            this.sha256 = string;
            this.fileNames = set;
            this.count = l;
        }

        @XmlElement
        public String getSha256() {
            return this.sha256;
        }

        public void setSha256(String string) {
            this.sha256 = string;
        }

        @XmlElement
        public Set<String> getFileNames() {
            return this.fileNames;
        }

        public void setFileNames(Set<String> set) {
            this.fileNames = set;
        }

        @XmlElement
        public long getCount() {
            return this.count;
        }

        public void setCount(long l) {
            this.count = l;
        }

        public void addFileName(String string, long l) {
            if (this.fileNames == null) {
                this.fileNames = new LinkedHashSet<String>();
            }
            this.fileNames.add(string);
            this.count += l;
        }

        @Override
        public int compareTo(Item item) {
            return Long.valueOf(this.count).compareTo(item.getCount());
        }
    }
}

