/*
 * Decompiled with CFR 0.152.
 */
package com.trendmicro.ds.platform.rest.object.scheduledtask;

import com.trendmicro.ds.platform.rest.object.scheduledtask.IScheduleParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="WeeklyScheduleParameters")
public class WeeklyScheduleParameters
implements IScheduleParameters {
    private Integer interval = 1;
    private List<Day> days = new ArrayList<Day>();

    @XmlElement(required=false)
    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer n) {
        this.interval = n;
    }

    public WeeklyScheduleParameters withInterval(Integer n) {
        this.interval = n;
        return this;
    }

    @XmlElement(required=false)
    public List<Day> getDays() {
        return this.days;
    }

    public void setDays(List<Day> list) {
        this.days = list;
    }

    public WeeklyScheduleParameters withDays(List<Day> list) {
        this.days = list;
        return this;
    }

    public WeeklyScheduleParameters withDays(Day ... dayArray) {
        this.days = Arrays.asList(dayArray);
        return this;
    }

    public WeeklyScheduleParameters addDay(Day day) {
        this.days.add(day);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WeeklyScheduleParameters\n");
        stringBuilder.append("interval = ");
        stringBuilder.append(this.interval);
        stringBuilder.append("\n");
        stringBuilder.append("days = ");
        stringBuilder.append(this.days);
        return stringBuilder.toString();
    }

    @XmlEnum
    public static enum Day {
        SUNDAY(0),
        MONDAY(1),
        TUESDAY(2),
        WEDNESDAY(3),
        THURSDAY(4),
        FRIDAY(5),
        SATURDAY(6);

        private final int value;

        private Day(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        public static Day forValue(int n) {
            for (Day day : Day.values()) {
                if (day.value != n) continue;
                return day;
            }
            throw new IllegalArgumentException("Day: " + n);
        }
    }
}

